/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.ClientInfo;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.UserInfo;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.impl.response.ErrorResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.ResponseData;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.SSLException;

public class HMCCommandsTask
implements Serializable {
    public Vector taskletOutput;
    public int taskletRC;
    private static final String TRACE_MASKD = "JCMDTSKD";
    private static final String TRACE_MASKF = "JCMDTSKF";
    private static final String TRACE_MASKT = "JCMDTSKT";
    public static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    public static final String HSC_COMMON_BUNDLE = "HSCCommonBundle";

    public void performCommand() throws Exception {
    }

    public int invokeViaTasklet() throws PIHscClientException, HSCException {
        UserInfo userInfo;
        String string = null;
        Object var2_2 = null;
        Client client = null;
        TaskletRequest taskletRequest = null;
        TaskletResponse taskletResponse = null;
        String string2 = null;
        String string3 = null;
        Locale locale = null;
        ConnectionFactory connectionFactory = null;
        ClientUserContext clientUserContext = null;
        this.taskletOutput = new Vector();
        this.taskletRC = 0;
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "invokeViaTasklet called from " + this.getClass().getName());
        }
        if ((userInfo = UserInfo.getUser()) != null) {
            string3 = userInfo.getUserName();
            locale = userInfo.getLocale();
        } else {
            string3 = PIHscUtil.getOriginalUser();
            locale = Locale.getDefault();
        }
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "invokeViaTasklet() userid=" + string3 + " locale=" + locale);
        }
        if ((string2 = ClientInfo.issueTicket(string3)) == null) {
            String[] stringArray = new String[]{"ClientInfo.issueTicket()"};
            throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_INTERNAL_ERROR", stringArray, null);
        }
        try {
            clientUserContext = new ClientUserContext(InetAddress.getByName("127.0.0.1"), 9940);
        }
        catch (UnknownHostException unknownHostException) {
            string = unknownHostException.getMessage();
            throw new HSCException(string);
        }
        if (clientUserContext == null) {
            String[] stringArray = new String[]{"new ClientUserContext()"};
            throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_INTERNAL_ERROR", stringArray, null);
        }
        clientUserContext.setLocale(locale);
        clientUserContext.attachToThread(true);
        connectionFactory = clientUserContext.getConnectionFactory();
        if (connectionFactory == null) {
            String[] stringArray = new String[]{"ClientUserContext.getConnectionFactory()"};
            throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_INTERNAL_ERROR", stringArray, null);
        }
        try {
            connectionFactory.setUserAndPassword(string3, string2.getBytes());
            connectionFactory.updateUserContext(clientUserContext);
        }
        catch (SSLException sSLException) {
            string = sSLException.getMessage();
            throw new HSCException(string);
        }
        catch (UnknownHostException unknownHostException) {
            string = unknownHostException.getMessage();
            throw new HSCException(string);
        }
        catch (Exception exception) {
            string = exception.getMessage();
            throw new HSCException(string);
        }
        try {
            taskletRequest = new TaskletRequest();
            taskletRequest.setData("CMD_CLASS", (Object)this);
            client = new Client("com.ibm.hsc.command.HMCCommandsTasklet", null);
            taskletResponse = client.init();
            taskletResponse = client.request(taskletRequest);
            ResponseData responseData = taskletResponse.getResponseData();
            if (responseData instanceof ErrorResponseData) {
                string = ((ErrorResponseData)responseData).getErrorMsg().toString();
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Received error response from tasklet:" + string);
                }
                throw new HSCException(string);
            }
            this.taskletRC = (Integer)taskletResponse.getData("RC");
            this.taskletOutput = (Vector)taskletResponse.getData("OUTPUT");
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "Received normal response from tasklet, RC=" + this.taskletRC);
            }
            if (this.taskletRC == -1) {
                Throwable throwable = (Throwable)this.taskletOutput.firstElement();
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Exception detected on tasklet side");
                    Trace.trace(TRACE_MASKF, throwable);
                }
                if (throwable instanceof PIHscClientException) {
                    throw new PIHscClientException(((PIHscClientException)throwable).getHscExId(), ((PIHscClientException)throwable).getBundleName(), ((PIHscClientException)throwable).getMsgId(), ((PIHscClientException)throwable).getArgs(), null);
                }
                throw new HSCException(throwable.getMessage());
            }
        }
        catch (TaskletException taskletException) {
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "Caught TaskletException");
                Trace.trace(TRACE_MASKF, (Object)taskletException);
            }
            string = taskletException.getMessage();
            throw new HSCException(string);
        }
        finally {
            if (client != null) {
                client.terminate();
            }
        }
        return this.taskletRC;
    }
}

